<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\PubsubLite;

class Reservation extends \Google\Model
{
  /**
   * The name of the reservation. Structured like: projects/{project_number}/loc
   * ations/{location}/reservations/{reservation_id}
   *
   * @var string
   */
  public $name;
  /**
   * The reserved throughput capacity. Every unit of throughput capacity is
   * equivalent to 1 MiB/s of published messages or 2 MiB/s of subscribed
   * messages. Any topics which are declared as using capacity from a
   * Reservation will consume resources from this reservation instead of being
   * charged individually.
   *
   * @var string
   */
  public $throughputCapacity;

  /**
   * The name of the reservation. Structured like: projects/{project_number}/loc
   * ations/{location}/reservations/{reservation_id}
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The reserved throughput capacity. Every unit of throughput capacity is
   * equivalent to 1 MiB/s of published messages or 2 MiB/s of subscribed
   * messages. Any topics which are declared as using capacity from a
   * Reservation will consume resources from this reservation instead of being
   * charged individually.
   *
   * @param string $throughputCapacity
   */
  public function setThroughputCapacity($throughputCapacity)
  {
    $this->throughputCapacity = $throughputCapacity;
  }
  /**
   * @return string
   */
  public function getThroughputCapacity()
  {
    return $this->throughputCapacity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Reservation::class, 'Google_Service_PubsubLite_Reservation');
