<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MigrationCenterAPI;

class ImportRowErrorXlsxErrorDetails extends \Google\Model
{
  /**
   * The row number where the error was detected.
   *
   * @var int
   */
  public $rowNumber;
  /**
   * The name of the sheet where the error was detected.
   *
   * @var string
   */
  public $sheet;

  /**
   * The row number where the error was detected.
   *
   * @param int $rowNumber
   */
  public function setRowNumber($rowNumber)
  {
    $this->rowNumber = $rowNumber;
  }
  /**
   * @return int
   */
  public function getRowNumber()
  {
    return $this->rowNumber;
  }
  /**
   * The name of the sheet where the error was detected.
   *
   * @param string $sheet
   */
  public function setSheet($sheet)
  {
    $this->sheet = $sheet;
  }
  /**
   * @return string
   */
  public function getSheet()
  {
    return $this->sheet;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ImportRowErrorXlsxErrorDetails::class, 'Google_Service_MigrationCenterAPI_ImportRowErrorXlsxErrorDetails');
