<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dns;

class Operation extends \Google\Model
{
  public const STATUS_pending = 'pending';
  public const STATUS_done = 'done';
  protected $dnsKeyContextType = OperationDnsKeyContext::class;
  protected $dnsKeyContextDataType = '';
  /**
   * Unique identifier for the resource. This is the client_operation_id if the
   * client specified it when the mutation was initiated, otherwise, it is
   * generated by the server. The name must be 1-63 characters long and match
   * the regular expression [-a-z0-9]? (output only)
   *
   * @var string
   */
  public $id;
  /**
   * @var string
   */
  public $kind;
  /**
   * The time that this operation was started by the server. This is in RFC3339
   * text format (output only).
   *
   * @var string
   */
  public $startTime;
  /**
   * Status of the operation. Can be one of the following: "PENDING" or "DONE"
   * (output only). A status of "DONE" means that the request to update the
   * authoritative servers has been sent, but the servers might not be updated
   * yet.
   *
   * @var string
   */
  public $status;
  /**
   * Type of the operation. Operations include insert, update, and delete
   * (output only).
   *
   * @var string
   */
  public $type;
  /**
   * User who requested the operation, for example: user@example.com. cloud-dns-
   * system for operations automatically done by the system. (output only)
   *
   * @var string
   */
  public $user;
  protected $zoneContextType = OperationManagedZoneContext::class;
  protected $zoneContextDataType = '';

  /**
   * Only populated if the operation targeted a DnsKey (output only).
   *
   * @param OperationDnsKeyContext $dnsKeyContext
   */
  public function setDnsKeyContext(OperationDnsKeyContext $dnsKeyContext)
  {
    $this->dnsKeyContext = $dnsKeyContext;
  }
  /**
   * @return OperationDnsKeyContext
   */
  public function getDnsKeyContext()
  {
    return $this->dnsKeyContext;
  }
  /**
   * Unique identifier for the resource. This is the client_operation_id if the
   * client specified it when the mutation was initiated, otherwise, it is
   * generated by the server. The name must be 1-63 characters long and match
   * the regular expression [-a-z0-9]? (output only)
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The time that this operation was started by the server. This is in RFC3339
   * text format (output only).
   *
   * @param string $startTime
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
  /**
   * Status of the operation. Can be one of the following: "PENDING" or "DONE"
   * (output only). A status of "DONE" means that the request to update the
   * authoritative servers has been sent, but the servers might not be updated
   * yet.
   *
   * Accepted values: pending, done
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * Type of the operation. Operations include insert, update, and delete
   * (output only).
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * User who requested the operation, for example: user@example.com. cloud-dns-
   * system for operations automatically done by the system. (output only)
   *
   * @param string $user
   */
  public function setUser($user)
  {
    $this->user = $user;
  }
  /**
   * @return string
   */
  public function getUser()
  {
    return $this->user;
  }
  /**
   * Only populated if the operation targeted a ManagedZone (output only).
   *
   * @param OperationManagedZoneContext $zoneContext
   */
  public function setZoneContext(OperationManagedZoneContext $zoneContext)
  {
    $this->zoneContext = $zoneContext;
  }
  /**
   * @return OperationManagedZoneContext
   */
  public function getZoneContext()
  {
    return $this->zoneContext;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Operation::class, 'Google_Service_Dns_Operation');
