<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dfareporting;

class ClickThroughUrlSuffixProperties extends \Google\Model
{
  /**
   * Click-through URL suffix to apply to all ads in this entity's scope. Must
   * be less than 128 characters long.
   *
   * @var string
   */
  public $clickThroughUrlSuffix;
  /**
   * Whether this entity should override the inherited click-through URL suffix
   * with its own defined value.
   *
   * @var bool
   */
  public $overrideInheritedSuffix;

  /**
   * Click-through URL suffix to apply to all ads in this entity's scope. Must
   * be less than 128 characters long.
   *
   * @param string $clickThroughUrlSuffix
   */
  public function setClickThroughUrlSuffix($clickThroughUrlSuffix)
  {
    $this->clickThroughUrlSuffix = $clickThroughUrlSuffix;
  }
  /**
   * @return string
   */
  public function getClickThroughUrlSuffix()
  {
    return $this->clickThroughUrlSuffix;
  }
  /**
   * Whether this entity should override the inherited click-through URL suffix
   * with its own defined value.
   *
   * @param bool $overrideInheritedSuffix
   */
  public function setOverrideInheritedSuffix($overrideInheritedSuffix)
  {
    $this->overrideInheritedSuffix = $overrideInheritedSuffix;
  }
  /**
   * @return bool
   */
  public function getOverrideInheritedSuffix()
  {
    return $this->overrideInheritedSuffix;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ClickThroughUrlSuffixProperties::class, 'Google_Service_Dfareporting_ClickThroughUrlSuffixProperties');
