<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CCAIPlatform;

class ShiftTemplate extends \Google\Collection
{
  protected $collection_key = 'eventTemplates';
  /**
   * Optional. A list of specific employee IDs that can be assigned to shifts
   * generated by this template. If this field is present, there will be
   * `EmployeeSchedule`s in the response for which the
   * `EmployeeSchedule.employee_id` field is set to one of the IDs in this list.
   * The number of employee schedules with an assigned employee ID will be
   * between `minimum_employee_count` and `maximum_employee_count`. If this
   * field is empty, between `minimum_employee_count` and
   * `maximum_employee_count` employees can be assigned to shifts generated by
   * this template and the employee schedules won't have an assigned employee
   * ID. Currently, only one assignable employee ID is supported.
   *
   * @var string[]
   */
  public $assignableEmployeeIds;
  /**
   * Fixed number of days off per week. An employee has a given day off if they
   * are not assigned to a shift that starts on that day. A week is 7 days and
   * begins on Sunday.
   *
   * @var int
   */
  public $daysOffCountPerWeek;
  protected $daysOffDatesType = DateList::class;
  protected $daysOffDatesDataType = '';
  /**
   * Required. Fixed duration of a shift generated by this template.
   *
   * @var int
   */
  public $durationMinutes;
  protected $earliestStartTimeType = TimeOfDay::class;
  protected $earliestStartTimeDataType = '';
  protected $eventTemplatesType = EventTemplate::class;
  protected $eventTemplatesDataType = 'array';
  /**
   * Required. Unique ID of this template.
   *
   * @var string
   */
  public $id;
  protected $latestStartTimeType = TimeOfDay::class;
  protected $latestStartTimeDataType = '';
  /**
   * Required. Maximum number of employees that can be assigned to all shifts
   * generated by this template on working days.
   *
   * @var int
   */
  public $maximumEmployeeCount;
  /**
   * Optional. Minimum number of employees that can be assigned to all shifts
   * generated by this template on working days.
   *
   * @var int
   */
  public $minimumEmployeeCount;
  /**
   * Optional. Minimum minutes between the end of one event and the start of the
   * next.
   *
   * @var int
   */
  public $minimumIntereventGapMinutes;
  /**
   * Optional. The time increment (in minutes) used to generate the set of
   * possible start times between `earliest_start_time` and `latest_start_time`.
   * For example, if the earliest start time is 8:00, the latest start time is
   * 8:30, and the start time increment is 10 minutes, then all possible start
   * times for this shift template are: 8:00, 8:10, 8:20, and 8:30.
   *
   * @var int
   */
  public $startTimeIncrementMinutes;

  /**
   * Optional. A list of specific employee IDs that can be assigned to shifts
   * generated by this template. If this field is present, there will be
   * `EmployeeSchedule`s in the response for which the
   * `EmployeeSchedule.employee_id` field is set to one of the IDs in this list.
   * The number of employee schedules with an assigned employee ID will be
   * between `minimum_employee_count` and `maximum_employee_count`. If this
   * field is empty, between `minimum_employee_count` and
   * `maximum_employee_count` employees can be assigned to shifts generated by
   * this template and the employee schedules won't have an assigned employee
   * ID. Currently, only one assignable employee ID is supported.
   *
   * @param string[] $assignableEmployeeIds
   */
  public function setAssignableEmployeeIds($assignableEmployeeIds)
  {
    $this->assignableEmployeeIds = $assignableEmployeeIds;
  }
  /**
   * @return string[]
   */
  public function getAssignableEmployeeIds()
  {
    return $this->assignableEmployeeIds;
  }
  /**
   * Fixed number of days off per week. An employee has a given day off if they
   * are not assigned to a shift that starts on that day. A week is 7 days and
   * begins on Sunday.
   *
   * @param int $daysOffCountPerWeek
   */
  public function setDaysOffCountPerWeek($daysOffCountPerWeek)
  {
    $this->daysOffCountPerWeek = $daysOffCountPerWeek;
  }
  /**
   * @return int
   */
  public function getDaysOffCountPerWeek()
  {
    return $this->daysOffCountPerWeek;
  }
  /**
   * Fixed dates when shifts from this template should not be generated.
   *
   * @param DateList $daysOffDates
   */
  public function setDaysOffDates(DateList $daysOffDates)
  {
    $this->daysOffDates = $daysOffDates;
  }
  /**
   * @return DateList
   */
  public function getDaysOffDates()
  {
    return $this->daysOffDates;
  }
  /**
   * Required. Fixed duration of a shift generated by this template.
   *
   * @param int $durationMinutes
   */
  public function setDurationMinutes($durationMinutes)
  {
    $this->durationMinutes = $durationMinutes;
  }
  /**
   * @return int
   */
  public function getDurationMinutes()
  {
    return $this->durationMinutes;
  }
  /**
   * Required. Earliest time in the day that a shift can start. This value is
   * specified with hours and minutes; seconds and nanos are ignored.
   *
   * @param TimeOfDay $earliestStartTime
   */
  public function setEarliestStartTime(TimeOfDay $earliestStartTime)
  {
    $this->earliestStartTime = $earliestStartTime;
  }
  /**
   * @return TimeOfDay
   */
  public function getEarliestStartTime()
  {
    return $this->earliestStartTime;
  }
  /**
   * Optional. Rules for generating events for each shift. Exactly one event
   * will be included in each shift for each `EventTemplate` specified.
   *
   * @param EventTemplate[] $eventTemplates
   */
  public function setEventTemplates($eventTemplates)
  {
    $this->eventTemplates = $eventTemplates;
  }
  /**
   * @return EventTemplate[]
   */
  public function getEventTemplates()
  {
    return $this->eventTemplates;
  }
  /**
   * Required. Unique ID of this template.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Required. Latest time in the day that a shift can start. This value is
   * specified with hours and minutes; seconds and nanos are ignored. If this
   * value is less than the `earliest_start_time`, it may imply an overnight
   * shift.
   *
   * @param TimeOfDay $latestStartTime
   */
  public function setLatestStartTime(TimeOfDay $latestStartTime)
  {
    $this->latestStartTime = $latestStartTime;
  }
  /**
   * @return TimeOfDay
   */
  public function getLatestStartTime()
  {
    return $this->latestStartTime;
  }
  /**
   * Required. Maximum number of employees that can be assigned to all shifts
   * generated by this template on working days.
   *
   * @param int $maximumEmployeeCount
   */
  public function setMaximumEmployeeCount($maximumEmployeeCount)
  {
    $this->maximumEmployeeCount = $maximumEmployeeCount;
  }
  /**
   * @return int
   */
  public function getMaximumEmployeeCount()
  {
    return $this->maximumEmployeeCount;
  }
  /**
   * Optional. Minimum number of employees that can be assigned to all shifts
   * generated by this template on working days.
   *
   * @param int $minimumEmployeeCount
   */
  public function setMinimumEmployeeCount($minimumEmployeeCount)
  {
    $this->minimumEmployeeCount = $minimumEmployeeCount;
  }
  /**
   * @return int
   */
  public function getMinimumEmployeeCount()
  {
    return $this->minimumEmployeeCount;
  }
  /**
   * Optional. Minimum minutes between the end of one event and the start of the
   * next.
   *
   * @param int $minimumIntereventGapMinutes
   */
  public function setMinimumIntereventGapMinutes($minimumIntereventGapMinutes)
  {
    $this->minimumIntereventGapMinutes = $minimumIntereventGapMinutes;
  }
  /**
   * @return int
   */
  public function getMinimumIntereventGapMinutes()
  {
    return $this->minimumIntereventGapMinutes;
  }
  /**
   * Optional. The time increment (in minutes) used to generate the set of
   * possible start times between `earliest_start_time` and `latest_start_time`.
   * For example, if the earliest start time is 8:00, the latest start time is
   * 8:30, and the start time increment is 10 minutes, then all possible start
   * times for this shift template are: 8:00, 8:10, 8:20, and 8:30.
   *
   * @param int $startTimeIncrementMinutes
   */
  public function setStartTimeIncrementMinutes($startTimeIncrementMinutes)
  {
    $this->startTimeIncrementMinutes = $startTimeIncrementMinutes;
  }
  /**
   * @return int
   */
  public function getStartTimeIncrementMinutes()
  {
    return $this->startTimeIncrementMinutes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShiftTemplate::class, 'Google_Service_CCAIPlatform_ShiftTemplate');
